package com.gogirl.domain.common.xcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-05
 * @Modified by:
 */
@ApiModel("小程序品牌配置")
@TableName("miniapp_brand_config")
@Data
public class MiniappBrandConfig implements Serializable {

    @JsonIgnore
    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "用户端小程序id")
    private String customerMiniappId;

    @ApiModelProperty("用户端小程序密钥")
    private String customerMiniappSecret;

    @ApiModelProperty("店员端小程序id")
    private String storeMiniappId;

    @ApiModelProperty("店员端小程序密钥")
    private String storeMiniappSecret;

    @JsonIgnore
    @ApiModelProperty("商户号id")
    private String mchId;

    @JsonIgnore
    @ApiModelProperty("商户号密钥")
    private String mchKey;

    @ApiModelProperty("预约提醒订阅消息模板id")
    private String scheduleTpl;

    @ApiModelProperty("预约过期订阅消息模板id")
    private String overScheduleTpl;

    @ApiModelProperty("支付成功订阅消息模板id")
    private String paySuccessTpl;

    @ApiModelProperty("订单支付订阅消息模板id")
    private String orderPayNotifyTpl;

    @ApiModelProperty("问卷调查消息模版")
    private String testPaperTpl;

    @ApiModelProperty("店铺预约小程序订阅消息模版")
    private String shopScheduleTpl;

    @ApiModelProperty("店铺预约超时小程序消息模版")
    private String shopOverScheduleTpl;

    @ApiModelProperty("用户取消店铺小程序订阅消息模版")
    private String shopCancelScheduleTpl;

    @ApiModelProperty("品牌id")
    private Integer brandId;

    @JsonIgnore
    private LocalDateTime createTime;

    @JsonIgnore
    private LocalDateTime lastUpdateTime;
}
