package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.application.product.serve.ITechniqueSkuService;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.TechniqueCategory;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechniqueCategoryMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechniqueSkuMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.validation.constraints.Null;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 技法sku 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Service
public class TechniqueSkuServiceImpl extends ServiceImpl<TechniqueSkuMapper, TechniqueSku> implements ITechniqueSkuService {

    @Resource
    TechniqueSkuMapper techniqueSkuMapper;
    @Resource
    TechniqueCategoryMapper techniqueCategoryMapper;

    @Override
    public List<TechniqueSku> queryAll(Integer brandId) {

        return techniqueSkuMapper.queryAll(brandId);
    }

    @Override
    public Map<String, List<TechniqueSku>> queryTechniqueSkuMap(Integer brandId) {

        List<TechniqueSku> techniqueSkuList = this.list(new LambdaQueryWrapper<TechniqueSku>().eq(TechniqueSku::getBrandId, brandId));
        List<TechniqueCategory> techniqueCategoryList = techniqueCategoryMapper.selectList(
                new LambdaQueryWrapper<TechniqueCategory>()
                        .eq(TechniqueCategory::getBrandId, brandId)
        );

        Map<Integer, List<TechniqueSku>> integerListMap = techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryId));

        Map<String, List<TechniqueSku>> result = new HashMap<>();
        techniqueCategoryList.forEach(techniqueCategory -> {
            result.put(JsonUtilByFsJson.beanToJson(techniqueCategory), integerListMap.get(techniqueCategory.getId()));
        });
        return result;
    }

    @Resource
    ScheduleServeMapper scheduleServeMapper;
    @Resource
    BaseServeMapper baseServeMapper;
    @Resource
    OrderServeMapper orderServeMapper;
    @Resource
    BaseServeService baseServeService;

    private static final String TECH_REMOVE_ARMOR = "卸甲";
    private static final String TECH_EXTEND = "光疗延长";


    @Override
    public List<TechniqueCategory> queryTechniqueCategoryAggregate(@Null Integer scheduleServeId,
                                                                   @Null Integer orderServeId,
                                                                   @Null Integer serveId,
                                                                   Integer brandId
    ) {
        List<TechniqueSku> techniqueSkuList = this.list();
        LambdaQueryWrapper<TechniqueCategory> wrapper = new LambdaQueryWrapper<>();

        if (serveId != null) {
            BaseServe baseServe = baseServeService.getAggregate(serveId);
            wrapper.eq(TechniqueCategory::getServiceTypeId, baseServe.getTypeId());
        }

        if (scheduleServeId != null) {

            ScheduleServe scheduleServe = scheduleServeMapper.selectById(scheduleServeId);

            ScheduleServe subRemoveArmor = scheduleServeMapper.subRemoveArmor(scheduleServe.getServeId(), scheduleServe.getSchId());
            ScheduleServe subExtend = scheduleServeMapper.subExtend(scheduleServe.getServeId(), scheduleServe.getSchId());


            if (subRemoveArmor != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_REMOVE_ARMOR);
            }
            if (subExtend != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_EXTEND);
            }
        }

        if (orderServeId != null) {
            OrderServe orderServe = orderServeMapper.selectById(orderServeId);
//            BaseServe baseServe = baseServeMapper.selectById(orderServe.getServeId());

//            wrapper.eq(TechniqueCategory::getServiceTypeId, baseServe.getTypeId());
            OrderServe subRemoveArmor = orderServeMapper.subRemoveArmor(orderServe.getServeId(), orderServe.getOrderId());
            OrderServe subExtend = orderServeMapper.subExtend(orderServe.getServeId(), orderServe.getOrderId());

            if (subRemoveArmor != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_REMOVE_ARMOR);
            }
            if (subExtend != null) {
                wrapper.ne(TechniqueCategory::getName, TECH_EXTEND);
            }

        }

        wrapper.eq(TechniqueCategory::getBrandId,brandId);

        List<TechniqueCategory> techniqueCategoryList = techniqueCategoryMapper.selectList(wrapper);
        Map<Integer, List<TechniqueSku>> integerListMap = techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryId));

        techniqueCategoryList.forEach(techniqueCategory -> {
            techniqueCategory.setTechniqueSkuList(integerListMap.get(techniqueCategory.getId()));
        });
        return techniqueCategoryList;
    }
}
