package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.domain.product.mall.PurchaseSku;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel("订单服务明细-sku")
@AllArgsConstructor
@NoArgsConstructor
@Data
@TableName("order_serve_sku")
@Builder
public class OrderServeSku {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("订单关联的服务id")
    private Integer orderServeId;

    @ApiModelProperty("skuId")
    private Integer skuId;

    @ApiModelProperty("purchase_sku  sku_type 1-色号  2-饰品")
    private Integer type;

    private String skuName;

    @TableField(value = "`count`")
    private Integer count;

    @TableField(exist = false)
    @ApiModelProperty("sku实体")
    private PurchaseSku purchaseSku;

}
