package com.gogirl.application.xcx;

import com.gogirl.domain.xcx.VisitsLog;

public interface VisitLogService {

    /**
     * 用户小程序登陆记录
     *
     * @param customerId
     * @return
     */
    VisitsLog loginLog(Integer customerId);

    /**
     * 小程序登出记录
     *
     * @param visitsId
     */
    void logoutLog(Integer visitsId);

    /**
     * 记录访问的活动
     *
     * @param visitsId
     * @param activityId
     */
    void recordActivityId(Integer visitsId, Integer activityId);

    /**
     * 页面登陆
     *
     * @param token
     */
    VisitsLog pageIn(Integer customerId,
                     Integer type,
                     Integer activityId,
                     Integer shareType,
                     Integer shareUserId,
                     Integer serviceId,
                     Integer departmentId,
                     String pageName,
                     Integer produceId);

    void pageOut(Integer visitsId);
}
