package com.gogirl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.application.market.CouponCustomerRelevanceService;
import com.gogirl.application.market.TimesCardCustomerRelevanceService;
import com.gogirl.application.market.TimesCardUsedRecordService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.pay.OrderPay;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.product.purchase.PurchaseStock;
import com.gogirl.domain.product.purchase.PurchaseStockRecord;
import com.gogirl.domain.store.complaint.ComplaintDetailed;
import com.gogirl.domain.store.complaint.ComplaintDetailedTechnician;
import com.gogirl.domain.store.complaint.ComplaintMain;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.TimeNode;
import com.gogirl.domain.xcx.WeekConfig;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigWeekMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.order.pay.OrderPayMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseStockMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseStockRecordMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintDetailedTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.complaint.ComplaintMainMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.TimeNodeMapper;
import com.gogirl.infrastructure.mapper.xcx.WeekConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class Test {

    @Resource
    private TimeNodeMapper timeNodeMapper;

    @org.junit.Test
    public void timeNode() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalTime localTime = LocalTime.of(0, 0);
        LocalTime localTime2 = LocalTime.of(23, 45);


        while (localTime.compareTo(localTime2) < 0) {
            TimeNode timeNode = new TimeNode();
            timeNode.setTimeNode(localTime);
            timeNodeMapper.insert(timeNode);
            localTime = localTime.plusMinutes(15);
        }
    }

    @Resource
    private LeisureDiscountConfigWeekMapper leisureDiscountConfigWeekMapper;
    @Resource
    private WeekConfigMapper weekConfigMapper;

    @org.junit.Test
    public void weekTest() throws ParseException {

        weekConfigMapper.delete(new LambdaQueryWrapper<>());

        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < 7; i++) {
            WeekConfig weekConfig = new WeekConfig();
            weekConfig.setWeek(localDate.getDayOfWeek().getValue());
            weekConfig.setWeekStr(localDate.getDayOfWeek().toString());
            weekConfig.setWeekDate(localDate);
            weekConfigMapper.insert(weekConfig);
            localDate = localDate.plusDays(1);
        }
    }

    @Resource
    OrderPayMapper orderPayMapper;
    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @org.junit.Test
    public void orderPay() {

        orderPayMapper.delete(new LambdaQueryWrapper<>());

        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .gt(OrderManage::getFinishTime, "2020-01-01"));


        // order_pay 微信 = 1, 会员 = 2, 充值 = 4, pos机 = 5, 大众点评 = 7, 会员帮付 = 11, 次卡 =12
        //1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付12#余额抵扣微信支付13余额pos支付
        orderManageList.forEach(orderManage -> {
            if (orderManage.getPaymentType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(1);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(2)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(2);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(5)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(5);
                orderPayMapper.insert(orderPay);
            }

            if (orderManage.getPaymentType().equals(12) || orderManage.getPaymentType().equals(13)) {

                try {
                    List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
                    multiPaymentTypeList.forEach(multiPaymentType -> {
                        if (multiPaymentType.getType().equals(1)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(1);
                            orderPayMapper.insert(orderPay);
                        }
                        if (multiPaymentType.getType().equals(2)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(2);
                            orderPayMapper.insert(orderPay);
                        }

                        if (multiPaymentType.getType().equals(5)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(5);
                            orderPayMapper.insert(orderPay);
                        }
                    });
                } catch (Exception e) {
                    log.error("orderId:no multi :{}", orderManage.getId());
                }
            }
        });

        orderPayMapper.delete(new LambdaQueryWrapper<OrderPay>().eq(OrderPay::getAmount, 0));
    }


    @org.junit.Test
    public void customerPay() {

        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.selectByOrderTimes();

        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            if (couponCustomerRelevance.getSourceType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(couponCustomerRelevance.getPayAmount());
                orderPay.setOrderId(couponCustomerRelevance.getOrderId());
                orderPay.setType(7);
                orderPayMapper.insert(orderPay);
            }
        });
    }

    @Resource
    RedisTemplate<String, String> redisTemplate;
    @Resource
    GogirlTokenService gogirlTokenService;
    @Resource
    CustomerMapper customerMapper;

    @org.junit.Test
    public void values() {
        Customer customer = customerMapper.selectById(20432);
        GogirlToken gogirlToken = GogirlToken.builder()
                .token(20432 + "_" + IdWorker.getIdStr().substring(6))
                .createTime(new Date())
                .openid(customer.getOpenid1())
                .customerId(20432)
                .build();
        gogirlTokenService.save(gogirlToken);
        System.out.println(gogirlToken.getToken());
    }

    @Resource
    ComplaintDetailedMapper complaintDetailedMapper;
    @Resource
    OrderServeMapper orderServeMapper;
    @Resource
    ComplaintMainMapper complaintMainMapper;
    @Resource
    ComplaintDetailedTechnicianMapper complaintDetailedTechnicianMapper;
    @Resource
    TimesCardCustomerRelevanceMapper timesCardCustomerRelevanceMapper;

    @org.junit.Test
    public void complain() {
        List<ComplaintDetailed> complaintDetailedList = complaintDetailedMapper.complainTest();

        complaintDetailedList.forEach(complaintDetailed -> {

            ComplaintMain complaintMain = complaintMainMapper.selectById(complaintDetailed.getMainId());
            List<Integer> technicianIds = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>()
                    .eq(OrderServe::getOrderId, complaintMain.getOrderId()))
                    .stream()
                    .map(OrderServe::getTechnicianId)
                    .map(id -> Lists.newArrayList(id.split(",")))
                    .flatMap(List::stream)
                    .map(Integer::valueOf)
                    .collect(Collectors.toList());
            technicianIds.forEach(technicianId -> {
                ComplaintDetailedTechnician complaintDetailedTechnician = new ComplaintDetailedTechnician();
                complaintDetailedTechnician.setTechnicianId(technicianId);
                complaintDetailedTechnician.setComplaintDetailedId(complaintDetailed.getId());
                complaintDetailedTechnicianMapper.insert(complaintDetailedTechnician);
            });

        });
    }

    @Resource
    CouponCustomerRelevanceService couponCustomerRelevanceService;
    @Resource
    TimesCardUsedRecordService timesCardUsedRecordService;
    @Resource
    TimesCardCustomerRelevanceService timesCardCustomerRelevanceService;
    @Resource
    StoreTechnicianService storeTechnicianService;
    @Resource
    CustomerBalanceRecordMapper customerBalanceRecordMapper;

    @org.junit.Test
    public void setChargeReferees() {
        log.debug("每天晚上11:50定时设置当天服务的技师为推荐人** 任务开始");

        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");

        String day = "2020-03-12";

        log.debug("设置推荐人:当天服务的技师为推荐人");
        Map<String, String> mapTechnicianManage = new HashMap<>();
        List<StoreTechnician> listTechnicianManage = storeTechnicianService.listTechnicianForPage(new StoreTechnician());

        //查出所有的技师,找到技师id和user_id
        for (StoreTechnician item : listTechnicianManage) {
            mapTechnicianManage.put(String.valueOf(item.getTechnicianId()), String.valueOf(item.getUserId()));
        }

        //找到当天的订单的推荐人
        List<CustomerBalanceRecord> list = customerBalanceRecordMapper.getXcxChargeRecord(day);

        //遍历设置推荐人
        for (CustomerBalanceRecord customerBalanceRecord : list) {

            //推荐人列表
            Map<String, String> map = new HashMap<>();
            //推荐人id
            StringBuilder referee_ids = new StringBuilder();
            //充值记录
            CustomerBalanceRecord cbrt = customerBalanceRecordMapper.selectByPrimaryKey(customerBalanceRecord.getId());
            //每次都修改推荐人,且每晚都会设置推荐人
            if (customerBalanceRecord.getRefereeId() != null) {
                String[] arr = customerBalanceRecord.getRefereeId().split(",");
                //
                for (String s : arr) {
                    if (!map.containsKey(s)) {
                        map.put(s, s);
                        referee_ids.append(",").append(mapTechnicianManage.get(s));
                    }
                }
                //去掉首尾,
                if (referee_ids.toString().startsWith(",")) {
                    referee_ids = new StringBuilder(referee_ids.substring(1));
                }
                customerBalanceRecord.setRefereeId(referee_ids.toString());
            }
            //如果店铺id不为空
            if (cbrt != null && cbrt.getDepartmentId() != null) {
                customerBalanceRecord.setDepartmentId(cbrt.getDepartmentId());
            }
            if (customerBalanceRecord.getId() != null
                    && (customerBalanceRecord.getRefereeId() != null || customerBalanceRecord.getDepartmentId() != null)) {
                customerBalanceRecordMapper.updateByPrimaryKeySelective(customerBalanceRecord);
            }
        }
        log.debug("每天晚上11:50定时设置当天服务的技师为推荐人** 任务结束");
    }



    @Resource
    PurchaseStockMapper purchaseStockMapper;
    @Resource
    PurchaseStockRecordMapper purchaseStockRecordMapper;

    @org.junit.Test
    public void stockTest() {
        List<PurchaseStock> purchaseStockList = purchaseStockMapper.selectList(
                new LambdaQueryWrapper<PurchaseStock>()
                        .eq(PurchaseStock::getDepartmentId, 0)
                        .ge(PurchaseStock::getSku, "MJJ00006")
                        .le(PurchaseStock::getSku, "MJJ00233")
                        .gt(PurchaseStock::getNum, 0));

        purchaseStockList.forEach(purchaseStock -> {
            purchaseStock.setNum(purchaseStock.getNum() - 1);
            purchaseStockMapper.updateById(purchaseStock);

            PurchaseStockRecord purchaseStockRecord = PurchaseStockRecord.builder()
                    .stockId(purchaseStock.getId())
                    .stockQuantity(purchaseStock.getNum())
                    .departmentId(0)
                    .quantity(1)
                    .remarks("excel批量出库")
                    .sku(purchaseStock.getSku())
                    .time(LocalDateTime.now())
                    .type(2)
                    .typeRemarks("excel批量出库")
                    .build();
            purchaseStockRecordMapper.insert(purchaseStockRecord);

        });


    }
}
