package com.gogirl.interfaces.common;

import com.gogirl.domain.common.xcx.MiniappBrandConfig;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.config.config.WxPayConfig;
import com.gogirl.shared.user.ReadMessageCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.lang.reflect.Field;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-12
 * @Modified by:
 */
@RestController
@AllArgsConstructor
@Api(tags = {"小程序配置"})
@Slf4j
public class MiniappBrandConfigController {

    @ApiModelProperty("获取小程序模板")
    @GetMapping(value = {"/customer/miniapp/brand/config/tpl","/technician/miniapp/brand/config/tpl"})
    public JsonResult<MiniappBrandConfig> tpl(@RequestHeader("brandId") Integer brandId) {
        MiniappBrandConfig config = WxPayConfig.brandMap.get(brandId);
        return JsonResult.success(config);
    }
}
