package com.gogirl.infrastructure.feign;

import com.gogirl.infrastructure.common.util.JsonUtilByJackson;
import com.gogirl.shared.admin.AdminResult;
import com.gogirl.shared.admin.dashboard.req.GetStoreTrendApiRequest;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 10:35 上午
 */
@ActiveProfiles("dev")
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@EnableFeignClients(clients = AdminFeign.class)
public class AdminFeignTest {

    @Resource
    private AdminFeign adminFeign;

    @Test
    public void getStoreTrendApi() {
        GetStoreTrendApiRequest request = new GetStoreTrendApiRequest();

        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        request.setSearchType(1);
        request.setUserStoreIds(Lists.newArrayList(19));
        request.setFields(Lists.newArrayList());

        String postJson = JsonUtilByJackson.writeValueAsString(request);
        log.info(postJson);
        AdminResult<GetStoreTrendApiResp> result = adminFeign.getStoreTrendApi(request);
        log.info("time end");
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }


    public void getStoreListApi() {

    }


    public void preStorageSumApi() {

    }

    public void revenueTypeListApi() {

    }


    public void revenueSumApi() {

    }

    @Test
    public void testTime() {
        System.out.println(LocalDateTime.now(ZoneOffset.UTC).toString());
        System.out.println(JsonUtilByJackson.writeValueAsString(LocalDateTime.now().toInstant(ZoneOffset.UTC)));
    }
}
