package com.gogirl.interfaces.dashboard;

import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:09 上午
 */
@Api(tags = "4.0报表")
@RestController
@RequestMapping("/technician/dashboard")
public class DashboardController  {
    @Resource
    AdminFeign adminFeign

    @PostMapping("/getStoreTrendApi")
    public JsonResult<GetStoreTrendApiResp> getStoreTrendApi(GetStoreTrendApiRequest request) {
        return JsonResult.success(adminFeign.getStoreTrendApi(request).getData());
    }

    @PostMapping("/getStoreListApi")
    public JsonResult<List<Map<String, Object>>> getStoreListApi(GetStoreListApiRequest request) {
        return JsonResult.success(adminFeign.getStoreListApi(request).getData());

    }

    @PostMapping("/preStorageSumApi")
    public JsonResult<Map<String, Object>> preStorageSumApi(PreStorageSumApiRequest request) {
        return JsonResult.success(adminFeign.preStorageSumApi(request).getData());

    }

    @PostMapping("/revenueTypeListApi")
    public JsonResult<List<Map<String, Object>>> revenueTypeListApi(RevenueTypeListRequest request) {
        return JsonResult.success(adminFeign.revenueTypeListApi(request).getData());

    }

    @PostMapping("/revenueSumApi")
    public JsonResult<Map<String, Object>> revenueSumApi(RevenueSumApiRequest request) {
        return JsonResult.success(adminFeign.revenueSumApi(request).getData());
    }
}
