package com.gogirl.interfaces.common;

import com.gogirl.application.common.xcx.VisitLogService;
import com.gogirl.domain.common.sys.VisitsLog;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/7/14 10:52 上午
 */
@RestController
@Api(tags = {"日志行为接口"})
public class LogController {

    @Resource
    private VisitLogService visitLogService;


    @AuthIgnore
    @ApiOperation(value = "小程序登入记录")
    @PostMapping("/customer/message/loginLog")
    public JsonResult<Integer> loginLog() {
        VisitsLog visitsLog = visitLogService.loginLog(SessionUtils.getCustomerId());
        return JsonResult.success(visitsLog.getId());
    }

    @LoginIgnore
    @AuthIgnore
    @ApiOperation(value = "小程序登出记录")
    @PostMapping("/customer/message/logoutLog")
    public JsonResult<Void> logoutLog(@RequestParam Integer visitsId) {
        visitLogService.logoutLog(visitsId);
        return JsonResult.success();
    }

    @ApiOperation(value = "记录该次访问的活动")
    @PostMapping("/customer/message/recordActivityId")
    public JsonResult<Void> recordActivityId(@RequestParam Integer visitsId,
                                             @RequestParam Integer activityId) {
        visitLogService.recordActivityId(visitsId, activityId);
        return JsonResult.success();

    }

    @LoginIgnore
    @AuthIgnore
    @ApiOperation(value = "页面登入记录", notes = "参数直接传过来")
    @PostMapping("/customer/message/pageIn")
    public JsonResult<Integer> pageIn(@RequestParam(required = false) Integer type,
                                      @RequestParam(required = false) Integer activityId,
                                      @RequestParam(required = false) Integer shareType,
                                      @RequestParam(required = false) Integer shareUserId,
                                      @RequestParam(required = false) Integer serviceId,
                                      @RequestParam(required = false) Integer departmentId,
                                      @RequestParam(required = false) String pageName,
                                      @RequestParam(required = false) Integer produceId) {

        Integer customerId = SessionUtils.getCustomerId();
        VisitsLog visitsLog = visitLogService.pageIn(customerId, type, activityId, shareType, shareUserId, serviceId, departmentId, pageName, produceId);
        return JsonResult.success(visitsLog.getId());
    }


    @LoginIgnore
    @AuthIgnore
    @ApiOperation(value = "页面登出记录")
    @PostMapping("/customer/message/pageOut")
    public JsonResult<Void> pageOut(@RequestParam Integer visitsId) {
        visitLogService.pageOut(visitsId);
        return JsonResult.success();
    }

    /*cmd接口结束*/
}
