package com.gogirl.application.product.serve;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.shared.product.serve.QueryProducePageRequest;

/**
 * Created by yinyong on 2018/8/23.
 * 服务款式 服务接口
 */
public interface BaseProduceService extends IService<BaseProduce> {

    /**
     * 查询款式详情
     *
     * @param id 款式id
     * @return 款式详情
     */
    BaseProduce getProduceForDetail(Integer id);


    /**
     * 点赞款式
     *
     * @param produceId
     */
    void praiseProduce(Integer produceId);

    /**
     * 分页查询款式列表
     *
     * @param request
     * @return
     */
    IPage<BaseProduce> queryProducePage(QueryProducePageRequest request);
}
