package com.gogirl.domain.order.market;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-03-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "TimesCardOrder对象", description = "")
@TableName("times_card_order")
@Builder
public class TimesCardOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private final Integer id;

    @ApiModelProperty(value = "客户id")
    private Integer customerId;

    @ApiModelProperty(value = "次卡订单编号")
    private String timesCardOrderNo;

    @ApiModelProperty(value = "次卡id")
    private Integer timesCardCustomerRelevanceId;

    @ApiModelProperty(value = "次卡种类id")
    private Integer timesCardTypeId;

    @ApiModelProperty(value = "次卡名称")
    private String timesCardName;

    @ApiModelProperty(value = "次卡支付金额")
    private BigDecimal payAmount;

    private LocalDateTime createTime;

    @ApiModelProperty(value = "1-已完成")
    private Integer status;


}
