package com.gogirl.shared.user;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ConsumerCommand {
    private Integer customerId;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("订单金额: 单位分")
    private Integer amount;

    @ApiModelProperty("订单状态")
    private Integer orderStatus;

    @ApiModelProperty("店铺id")
    private Integer departmentId;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    @ApiModelProperty("这笔记录来自于哪里：1:充值，2:首次充值，-1:订单扣款.3:充送 4-余额迁入5-余额迁出6-次卡扣款7-商城扣款")
    private Integer type = -1;
}
