package com.gogirl.shared.member;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class ImmediatePurchaseCommand implements Serializable {

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("配送方式 1-邮寄 2-自取")
    private Integer transportMode;

    @ApiModelProperty("运费")
    private BigDecimal freight;

    @ApiModelProperty("顾客留言备注")
    private String customerRemark;

    @ApiModelProperty(value = "配送地址id", required = true)
    private Long mallCustomerAddressId;

    @ApiModelProperty("自提店铺id")
    private Integer selfTakeDepartmentId;

    @ApiModelProperty("自提客户手机号")
    private String selfTakePhone;

    @ApiModelProperty("自提店铺地址")
    private String selfTakeDepartmentAddress;

    @ApiModelProperty("购物车id")
    private Long productId;

    private Integer num;

    @ApiModelProperty("支付方式 1-微信支付 2-余额支付 4-代理余额")
    private Integer paymentType;

    /**
     * 命令执行结果 订单id
     */
    private Long executionResult;

    private List<Integer> technicianIdList;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

}
