package com.gogirl.interfaces.order.mall;


import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.order.mall.MallOrderPayService;
import com.gogirl.application.order.mall.MallOrderService;
import com.gogirl.application.order.mall.MallRefundOrderService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.order.mall.MallOrder;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.shared.market.SubmitMallOrderCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.net.UnknownHostException;

@Api(tags = "商城订单支付接口", value = "商城订单支付接口")
@RestController
@AllArgsConstructor
@Slf4j
public class MallOrderPayController {


    private final MallOrderPayService mallOrderPayService;
    private final MallRefundOrderService mallRefundOrderService;
    private final MallOrderService mallOrderService;


    @ApiOperation("微信支付")
    @GetMapping("/customer/mallOrderPay/payMallOrder/{mallOrderId}")
    public JsonResult<WxPayMpOrderResult> wxPayMallOrder(@PathVariable Long mallOrderId) throws UnknownHostException, WxPayException {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        WxPayMpOrderResult result = mallOrderPayService.wxPayMallOrder(currentCustomerId, mallOrderId);
        log.info("微信支付参数：{}", result);
        return JsonResult.success(result);
    }

    @LoginIgnore
    @AuthIgnore
    @ApiOperation(value = "用户端微信支付回调")
    @PostMapping("/customer/mallOrderPay/notifyMallOrder")
    public String notifyOrder(@RequestBody String xmlData) {
        log.info("支付回调参数xmlData:" + xmlData);
        WxPayOrderNotifyResult result = WxPayOrderNotifyResult.fromXML(xmlData);

        if (result.getReturnCode().equals("SUCCESS") && result.getResultCode().equals("SUCCESS")) {
            mallOrderPayService.notifyMallOrder(Long.valueOf(result.getOutTradeNo()));
        }
        return WxPayNotifyResponse.success("成功");
    }


    @ApiOperation("代理余额支付")
    @GetMapping("/customer/mallOrderPay/balancePayMallOrder/{mallOrderId}")
    public JsonResult<Integer> agentBalancePayMallOrder(@RequestHeader String token,
                                                   @PathVariable Long mallOrderId) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallOrderPayService.balancePayMallOrder(currentCustomerId, mallOrderId);
        return JsonResult.success();
    }

    @ApiOperation("用户余额支付")
    @PostMapping("/customer/mallOrderPay/customerBalancePayMallOrder")
    public JsonResult<Long> customerBalancePayMallOrder(@RequestBody SubmitMallOrderCommand cmd) {
        log.info("token:{}", SessionUtils.getCustomerToken().toString());
        GogirlToken gogirlToken = SessionUtils.getCustomerToken();
        cmd.setCustomerId(gogirlToken.getCustomerId());
        cmd.setBrandId(gogirlToken.getBrandId());
        cmd.setPaymentType(MallOrder.PAYMENT_TYPE_BALANCE);
        mallOrderPayService.submitMallOrderAndPay(cmd);
        //mallOrderService.submitMallOrder(cmd);
        //MallOrder mallOrder = mallOrderService.getMallOrderAggregate(cmd.getExecutionResult());
        return JsonResult.success(cmd.getExecutionResult());
    }


    @ApiOperation("余额抵扣的微信支付")
    @GetMapping("/customer/mallOrderPay/balanceWxPayMallOrder/{mallOrderId}")
    public JsonResult<WxPayMpOrderResult> balanceWxPayMallOrder(@RequestHeader String token,
                                                                @PathVariable Long mallOrderId) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        WxPayMpOrderResult result = mallOrderPayService.balanceWxPayMallOrder(currentCustomerId, mallOrderId);
        return JsonResult.success(result);
    }

    @ApiOperation("朋友代付")
    @GetMapping("/customer/mallOrderPay/friendPayMallOrder/{mallOrderId}")
    public JsonResult<Integer> friendPayMallOrder(@RequestHeader String token,
                                                  @PathVariable Long mallOrderId,
                                                  @ApiParam("朋友手机号")
                                                  @RequestParam String phone) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallOrderPayService.friendPayMallOrder(currentCustomerId, mallOrderId, phone);
        return JsonResult.success();
    }


    @AuthIgnore
    @LoginIgnore
    @ApiOperation(("/确认退款"))
    @GetMapping("/customer/mallOrderPay/refund/{orderDetailId}")
    public JsonResult<Void> refund(@PathVariable Long orderDetailId) throws WxPayException {
        mallRefundOrderService.refund(orderDetailId);
        return JsonResult.success();
    }
}
