package com.gogirl.interfaces.market.gift;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.market.gift.GiftCardCustomerRelevanceService;
import com.gogirl.application.market.gift.GiftCardService;
import com.gogirl.domain.market.gift.GiftCardCustomerRelevance;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@RestController
@Api(tags = {"礼品卡接口"})
@AllArgsConstructor
@Slf4j
public class GiftCardController {

    private final GiftCardService giftCardService;

    private final GiftCardCustomerRelevanceService giftCardCustomerRelevanceService;

    @ApiOperation(value = "用户礼品卡列表")
    @GetMapping("/customer/giftCard/myGiftCard")
    public JsonResult<IPage<GiftCardCustomerRelevance>> myGiftCard(@RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                   @RequestParam Integer status,
                                                                   @RequestHeader("brandId") Integer brandId) {
        Integer customerId = SessionUtils.getCustomerId();
        Page page = new Page(pageNum, pageSize);
        IPage<GiftCardCustomerRelevance> giftCardCustomerRelevancePage = giftCardCustomerRelevanceService.getMyGiftCard(page, customerId, status, brandId);
        return JsonResult.success(giftCardCustomerRelevancePage);
    }

    @ApiOperation(value = "我核销的礼品卡列表")
    @GetMapping("/technician/giftCard/myWriteOffGiftCard")
    public JsonResult<IPage<GiftCardCustomerRelevance>> getMyWriteOffGiftCard(@RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(required = false, defaultValue = "20") Integer pageSize,
                                                                              @RequestHeader("brandId") Integer brandId) {
        Integer technicianId = SessionUtils.getTechnicianId();
        Page page = new Page(pageNum, pageSize);
        IPage<GiftCardCustomerRelevance> giftCardCustomerRelevancePage = giftCardCustomerRelevanceService.getMyWriteOffGiftCard(page, technicianId, brandId);
        return JsonResult.success(giftCardCustomerRelevancePage);
    }

    @ApiOperation(value = "员工端检查礼品卡")
    @GetMapping("/technician/giftCard/check")
    public JsonResult<GiftCardCustomerRelevance> getGiftCardByCode(@RequestParam String code, @RequestHeader("brandId") Integer brandId) {
        return JsonResult.success(giftCardCustomerRelevanceService.getGiftCardByCode(code, brandId));
    }

    @ApiOperation(value = "核销礼品卡")
    @PutMapping("/technician/giftCard/writeOff")
    public JsonResult<Void> writeOff(@RequestParam String code,
                                     @RequestHeader("brandId") Integer brandId) {
        Integer technicianId = SessionUtils.getTechnicianId();
        giftCardCustomerRelevanceService.writeOff(technicianId, code, brandId);
        return JsonResult.success();
    }
}
