package com.gogirl.interfaces.customer;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.customer.ICustomerInfoEnumService;
import com.gogirl.domain.customer.CustomerInfoEnum;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@RestController
@RequestMapping("/technician/customerInfoEnum")
public class CustomerInfoEnumController {

    @Resource
    ICustomerInfoEnumService customerInfoEnumService;

    @AuthIgnore
    @LoginIgnore
    @ApiOperation("职业偏好查询")
    @GetMapping("/list")
    public JsonResult<List<CustomerInfoEnum>> list(@RequestHeader("brandId") Integer brandId) {
        return JsonResult.success(customerInfoEnumService.list(new LambdaQueryWrapper<CustomerInfoEnum>()
                .eq(CustomerInfoEnum::getBrandId, brandId)));
    }
}
