package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.market.discount.DiscountConfig;
import com.gogirl.domain.store.store.StoreUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel("会员卡")
@AllArgsConstructor
@Builder
@TableName("customer_balance")
@Data
public class CustomerBalance implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("余额")
    private Integer balance;

    @ApiModelProperty("首次充值时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstChargeTime;

    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("总充值金额")
    private Integer totalCharge;

    @ApiModelProperty("总送金额")
    private Integer totalBestow;

    @ApiModelProperty("总花费金额")
    private Integer totalExpenditure;

    @Version
    private Integer version;

    @ApiModelProperty("会员级别 ")
    private String level;

    @ApiModelProperty("推荐人")
    private String refereeId;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    @ApiModelProperty("顾客id")
    @TableField(exist = false)
    private StoreUser referee;

    @ApiModelProperty("折扣，显示用,如9.5折")
    private BigDecimal currentDiscount;

    @ApiModelProperty("折扣率，如0.95，0.5")
    private BigDecimal discountRate;

    @ApiModelProperty("服务是否按现价打折(按原价/现价)，DACP discount at current price")
    private Boolean serveDacp;

    @ApiModelProperty("商城产品是否按现价打折，DACP discount at current price")
    private Boolean productDacp;

    @ApiModelProperty("服务是否可用余额支付")
    private Boolean servePayAtBalance;

    @ApiModelProperty("产品是否可用余额支付")
    private Boolean productPayAtBalance;

    @ApiModelProperty("次卡是否可用余额支付")
    private Boolean timesCardPayAtBalance;

    public CustomerBalance(Integer customerId,
                           Integer balance,
                           Date firstChargeTime,
                           Date updateTime,
                           Integer totalCharge,
                           Integer totalExpenditure,
                           Integer version,
                           BigDecimal discountRate,
                           Integer totalBestow, String level) {
        super();
        this.customerId = customerId;
        this.balance = balance;
        this.firstChargeTime = firstChargeTime;
        this.updateTime = updateTime;
        this.totalCharge = totalCharge;
        this.totalExpenditure = totalExpenditure;
        this.version = version;
        this.totalBestow = totalBestow;
        this.level = level;
        this.setDiscount(discountRate);
        this.servePayAtBalance = false;
        this.productPayAtBalance = false;
        this.timesCardPayAtBalance = false;
    }

    public CustomerBalance() {

    }

    /**
     * 设置折扣配置
     * @param config
     */
    public void setDiscountConfig(DiscountConfig config){
        this.discountRate = config.getDiscount();
        this.currentDiscount = discountRate.multiply(new BigDecimal("10"));
        this.serveDacp = config.getServeDacp();
        this.productDacp = config.getProductDacp();
        this.servePayAtBalance = config.getServePayAtBalance();
        this.productPayAtBalance = config.getProductPayAtBalance();
        this.timesCardPayAtBalance = config.getTimesCardPayAtBalance();
    }

    /**
     * 设置折扣 如1.0，0.95
     * @param discountRate
     */
    public void setDiscount(BigDecimal discountRate){
        this.discountRate = discountRate;
        this.currentDiscount = discountRate.multiply(new BigDecimal("10"));
        this.serveDacp = true;
        this.productDacp = true;
    }

    public static CustomerBalance getInstance(Integer customerId, Integer brandId) {
        //新建会员卡
        CustomerBalance customerBalance = CustomerBalance.builder()
                .balance(0)
                .customerId(customerId)
                .firstChargeTime(new Date())
                .level("普通会员")
                .totalBestow(0)
                .totalCharge(0)
                .totalExpenditure(0)
                .version(1)
                .updateTime(new Date())
                .brandId(brandId)
                .servePayAtBalance(false)
                .productPayAtBalance(false)
                .timesCardPayAtBalance(false)
                .build();
        customerBalance.setDiscount(new BigDecimal("1"));
        return customerBalance;
    }
}
