package com.gogirl.domain.market.gift;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@ApiModel("礼品卡领取记录表")
@Data
@TableName("gift_card_customer_relevance")
@Builder
public class GiftCardCustomerRelevance {
    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("顾客Id")
    private Integer customerId;

    @ApiModelProperty("礼品卡id")
    private Integer giftCardId;

    @ApiModelProperty("礼品卡码")
    private String code;

    @ApiModelProperty("发卡日期")
    private LocalDate issueDate;

    @ApiModelProperty("有效期至")
    private LocalDateTime validDate;

    @ApiModelProperty("核销时间")
    private LocalDateTime writeOffTime;

    @ApiModelProperty("核销员工")
    private Integer technicianId;

    @ApiModelProperty("状态，0 未使用，1 已使用，2 已过期")
    private Integer status;

    @ApiModelProperty("品牌id")
    private Integer brandId;

    @TableField(exist = false)
    private GiftCard giftCard;

    public static GiftCardCustomerRelevance getInstance(GiftCard giftCard, Integer customerId){
        GiftCardCustomerRelevance giftCardCustomerRelevance = GiftCardCustomerRelevance
                .builder()
                .customerId(customerId)
                .giftCardId(giftCard.getId())
                .code(IdUtil.simpleUUID().toUpperCase())
                .issueDate(LocalDate.now())
                .validDate(LocalDateTime.now().plusDays(giftCard.getValidDate()))
                .status(0)
                .brandId(giftCard.getBrandId())
                .build();
        return giftCardCustomerRelevance;
    }
}
