package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseTypeService;
import com.gogirl.domain.product.serve.BaseType;
import com.gogirl.infrastructure.mapper.product.serve.BaseTypeMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by yinyong on 2018/9/4.
 */
@Service
public class BaseTypeServiceImpl extends ServiceImpl<BaseTypeMapper, BaseType> implements BaseTypeService {

    @Resource
    private BaseTypeMapper baseTypeMapper;

    @Override
    public boolean containFreeServe(List<Integer> serveIdList) {

        List<BaseType> baseTypeList = baseTypeMapper.selectByServeIds(serveIdList);
        return baseTypeList.stream().map(BaseType::getName).collect(Collectors.toList()).contains("会员福利");
    }

    @Override
    public List<BaseType> queryType(Integer brandId) {

        return baseMapper.selectList(
                new LambdaQueryWrapper<BaseType>()
                        .eq(BaseType::getIsShow,1)
                        .eq(BaseType::getBrandId,brandId)
                        .orderByAsc(BaseType::getSorts)
        );
    }
}
