package com.gogirl.application.market.gift.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.gift.GiftCardCustomerRelevanceService;
import com.gogirl.domain.market.gift.GiftCard;
import com.gogirl.domain.market.gift.GiftCardCustomerRelevance;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.market.gift.GiftCardCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.gift.GiftCardMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
@Service
public class GiftCardCustomerRelevanceServiceImpl extends ServiceImpl<GiftCardCustomerRelevanceMapper, GiftCardCustomerRelevance> implements GiftCardCustomerRelevanceService {

    @Resource
    private GiftCardMapper giftCardMapper;

    @Override
    public IPage<GiftCardCustomerRelevance> getMyGiftCard(Page page, Integer customerId, Integer status, Integer brandId) {
        LambdaQueryWrapper<GiftCardCustomerRelevance> wrapper = new LambdaQueryWrapper<GiftCardCustomerRelevance>()
                .eq(GiftCardCustomerRelevance::getCustomerId, customerId);
        if (status.equals(2)) {
            //已过期，有效期小于当前，并且状态小于2
            wrapper.le(GiftCardCustomerRelevance::getValidDate, LocalDateTime.now())
                    .lt(GiftCardCustomerRelevance::getStatus, 2);
        } else if (Arrays.asList(0, 1).contains(status)) {
            //未过期
            wrapper.eq(GiftCardCustomerRelevance::getStatus, status);
        } else
            throw new RRException("状态异常");
        wrapper.eq(GiftCardCustomerRelevance::getBrandId, brandId)
                .orderByDesc(GiftCardCustomerRelevance::getValidDate);
        IPage<GiftCardCustomerRelevance> result = this.page(page, wrapper);
        if (ObjectUtil.isNotNull(result.getRecords()) && !result.getRecords().isEmpty()) {
            Optional.ofNullable(giftCardMapper.selectBatchIds(result.getRecords().stream().map(GiftCardCustomerRelevance::getGiftCardId).collect(Collectors.toList())))
                    .ifPresent(giftCards -> giftCards.forEach(giftCard -> {
                        result.getRecords()
                                .stream()
                                .filter(giftCardCustomerRelevance -> giftCardCustomerRelevance.getGiftCardId().equals(giftCard.getId()))
                                .findAny()
                                .ifPresent(x -> x.setGiftCard(giftCard));
                    }));
        }
        return result;
    }

    @Override
    public IPage<GiftCardCustomerRelevance> getMyWriteOffGiftCard(Page page, Integer technicianId, Integer brandId) {
        LambdaQueryWrapper<GiftCardCustomerRelevance> wrapper = new LambdaQueryWrapper<GiftCardCustomerRelevance>()
                .eq(GiftCardCustomerRelevance::getTechnicianId, technicianId)
                .eq(GiftCardCustomerRelevance::getStatus, 1)
                .eq(GiftCardCustomerRelevance::getBrandId, brandId)
                .orderByDesc(GiftCardCustomerRelevance::getWriteOffTime);
        IPage<GiftCardCustomerRelevance> result = this.page(page, wrapper);
        if (ObjectUtil.isNotNull(result.getRecords()) && !result.getRecords().isEmpty()) {
            Optional.ofNullable(giftCardMapper.selectBatchIds(result.getRecords().stream().map(GiftCardCustomerRelevance::getGiftCardId).collect(Collectors.toList())))
                    .ifPresent(giftCards -> giftCards.forEach(giftCard -> {
                        result.getRecords()
                                .stream()
                                .filter(giftCardCustomerRelevance -> giftCardCustomerRelevance.getGiftCardId().equals(giftCard.getId()))
                                .findAny()
                                .ifPresent(x -> x.setGiftCard(giftCard));
                    }));
        }
        return result;
    }

    @Override
    public GiftCardCustomerRelevance getGiftCardByCode(String code, Integer brandId) {
        GiftCardCustomerRelevance giftCardCustomerRelevance = this.getOne(new LambdaQueryWrapper<GiftCardCustomerRelevance>()
                .eq(GiftCardCustomerRelevance::getCode, code)
                .eq(GiftCardCustomerRelevance::getBrandId, brandId));
        GiftCard giftCard = giftCardMapper.selectOne(new LambdaQueryWrapper<GiftCard>().eq(GiftCard::getId, giftCardCustomerRelevance.getGiftCardId()).eq(GiftCard::getBrandId, brandId));
        if (giftCardCustomerRelevance.getValidDate().compareTo(LocalDateTime.now()) < 0) {
            //前端 2 为过期
            giftCardCustomerRelevance.setStatus(2);
        }
        giftCardCustomerRelevance.setGiftCard(giftCard);
        return giftCardCustomerRelevance;
    }

    @Override
    public void writeOff(Integer technicianId, String code, Integer brandId) {
        LocalDateTime now = LocalDateTime.now();
        GiftCardCustomerRelevance giftCardCustomerRelevance = this.getOne(new LambdaQueryWrapper<GiftCardCustomerRelevance>()
                .eq(GiftCardCustomerRelevance::getCode, code)
                .eq(GiftCardCustomerRelevance::getBrandId, brandId));
        if (!giftCardCustomerRelevance.getStatus().equals(0)) {
            throw new RRException("礼品卡已使用");
        }
        if (giftCardCustomerRelevance.getValidDate().compareTo(now) < 0) {
            throw new RRException("礼品卡已过期");
        }
        giftCardCustomerRelevance.setTechnicianId(technicianId);
        giftCardCustomerRelevance.setStatus(1);
        giftCardCustomerRelevance.setWriteOffTime(now);
        this.updateById(giftCardCustomerRelevance);
    }
}
