package com.gogirl.application.market.gift;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.market.gift.GiftCardCustomerRelevance;

import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
public interface GiftCardCustomerRelevanceService extends IService<GiftCardCustomerRelevance> {

    /**
     * 我的礼品卡
     *
     * @param page
     * @param status
     * @param brandId
     * @return
     */
    IPage<GiftCardCustomerRelevance> getMyGiftCard(Page page, Integer customerId, Integer status, Integer brandId);

    /**
     * 我核销的的礼品卡（店员端）
     *
     * @param page
     * @param technicianId
     * @param brandId
     * @return
     */
    IPage<GiftCardCustomerRelevance> getMyWriteOffGiftCard(Page page, Integer technicianId, Integer brandId);

    /**
     * 根据礼品卡号获取礼品信息
     *
     * @param code
     * @param brandId
     * @return
     */
    GiftCardCustomerRelevance getGiftCardByCode(String code, Integer brandId);

    /**
     * 核销礼品卡
     *
     * @param code
     * @param brandId
     * @return
     */
    void writeOff(Integer technicianId, String code, Integer brandId);
}
