package com.gogirl.domain.xcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@ApiModel("系统日志")
@Data
@TableName("sys_log")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysLog implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("表名")
    private String tableName;

    @ApiModelProperty("字段名")
    private String field;

    @ApiModelProperty("创建用户")
    private Integer createUser;

    @ApiModelProperty("创建用户名称")
    private String createUserName;

    @ApiModelProperty("旧值")
    private String oldVal;

    @ApiModelProperty("新值")
    private String newVal;

    @ApiModelProperty("创建时间")
    private Date createDate;

    private Long manId;
}
