package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.market.timescard.TimesCardUsedRecord;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel("订单所选的服务详情")
//@Builder
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
@TableName("order_serve")
@Getter
@Setter
public class OrderServe implements Serializable {


    @Builder.Default
    public final static Integer COMMENT_STATUS_NO = 1;
    @Builder.Default
    public final static Integer COMMENT_STATUS_YES = 2;
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Integer id;

    public Integer getOwnProduceId() {
        return ownProduceId;
    }

    public void setOwnProduceId(Integer ownProduceId) {
        this.ownProduceId = ownProduceId;
    }

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("服务美甲顾问id")
    private String technicianId;

    @ApiModelProperty("订单美甲师姓名")
    private String technicianName;

    @ApiModelProperty("业绩")
    private BigDecimal achievement;

    @ApiModelProperty("服务评价状态 1-未评价 2-已评价")
    private Integer commentStatus;

    /**
     * 价格信息
     */
    @ApiModelProperty("服务改价(有正负)")
    private BigDecimal serveChangePrice = BigDecimal.ZERO;

    @ApiModelProperty("价格")
    private BigDecimal price = BigDecimal.ZERO;

    @ApiModelProperty("优惠券折扣金额")
    private BigDecimal discountPrice = BigDecimal.ZERO;

    @ApiModelProperty("支付金额")
    private BigDecimal payPrice = BigDecimal.ZERO;

    /**
     * 预约服务vo
     */
    @ApiModelProperty("服务数量")
    private Integer serveNumber;
    @ApiModelProperty("预约服务id")
    private Integer serveId;
    @ApiModelProperty("服务名称")
    private String serveName;
    @ApiModelProperty("图片名称")
    private String servePicturePath;
    @ApiModelProperty("服务价格")
    private BigDecimal servePrice;
    @ApiModelProperty("服务分类")
    private String serveType;

    private Integer serveTypeId;

    private Integer mainServeId;

    private Integer mainOrderServeId;

    /**
     * 预约款式vo
     */
    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("预约款式id")
    private Integer produceId;

    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("款式名称")
    private String produceName;

    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("款式图片地址")
    private String producePicturePath;

    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("款式当前价格")
    private BigDecimal produceCurrentPrice;

    @TableField(strategy = FieldStrategy.IGNORED)
    @ApiModelProperty("款式特价")
    private BigDecimal produceBargainPrice;

    /**
     * base info
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("标记")
    private String remark;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date scheduledTime;

    @ApiModelProperty("订单服务实际开始时间")
    @JsonFormat(pattern = "HH:mm", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("订单服务实际结束时间")
    @JsonFormat(pattern = "HH:mm", timezone = "GMT+8")
    private Date endTime;

    private Integer executionStatus;

    @ApiModelProperty("评论分数")
    private Integer commentScore;

    private Integer removeCouponId;

    @ApiModelProperty("闲时折扣配置id")
    private Integer leisureDiscountConfigId;

    /**
     * 非数据库字段
     */
    @ApiModelProperty("订单记录")
    @TableField(exist = false)
    private OrderRecord orderRecord;

    @TableField(exist = false)
    private BaseServe serve;

    @TableField(exist = false)
    private BaseProduce produce;

    @TableField(exist = false)
    private StoreTechnician technicianManage;

    @TableField(exist = false)
    private List<StoreTechnician> listTechnicianManage;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(exist = false)
    private Date startDate;

    @TableField(exist = false)
    private Integer updateType = 0;

    @TableField(exist = false)
    private Boolean canReplace = false;

    @TableField(exist = false)
    private String nickName;

    @TableField(exist = false)
    private String customerPhone;

    @TableField(exist = false)
    private String storeRecordRealName;

    @TableField(exist = false)
    private Integer isCountAchievement = 0;

    @ApiModelProperty("订单服务sku")
    @TableField(exist = false)
    private List<OrderServeSku> listOrderServeSku;

    @ApiModelProperty("订单服务sku详情")
    @TableField(exist = false)
    private List<OrderServeDescribe> listOrderServeDescribe;

    @TableField(exist = false)
    @ApiModelProperty("美甲顾问id")
    private String technicianIds;

//    @TableField(exist = false)
//    @ApiModelProperty("预约美甲师姓名")
//    private String technicianNames;

    @TableField(exist = false)
    private Integer lengthTime;

    @ApiModelProperty("服务实际时长")
    @TableField(exist = false)
    private Integer actualServeDuration;

    @ApiModelProperty("服务配置时长")
    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer serveDuration;

//    @ApiModelProperty("是否已经被卡券或者次卡折扣过 1-已经绑定了次卡或者优惠券 2-未绑定")
//    private Integer bindCoupon = 2;

    @ApiModelProperty("是否已经绑定了内部券 1-已经绑定了内部券 2-未绑定")
    private Integer bindInnerCoupon = 2;

    @ApiModelProperty("是否已经绑定了外部券 1-已经绑定了外部券 2-未绑定")
    private Integer bindOuterCoupon = 2;

    @ApiModelProperty("是否已经绑定了次卡 1-已经绑定了次卡 2-未绑定")
    private Integer bindTimesCard = 2;

    @TableField(strategy = FieldStrategy.IGNORED)
    private BigDecimal promotionPrice;

    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer producePromotionTimeId;

    @ApiModelProperty("折扣")
    private BigDecimal discountRate;

    @ApiModelProperty("闲时价格")
    private BigDecimal leisurePrice;

    @TableField(exist = false)
    private String picturePath;

    @ApiModelProperty("是否自带款式 1-是 2-否")
    private Integer isOwnProduce;

    @ApiModelProperty("自带款式id")
    @TableField(strategy = FieldStrategy.IGNORED)
    private Integer ownProduceId;

    @TableField(exist = false)
    private OwnProduce ownProduce;


    public void addDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = this.discountPrice.add(discountPrice);
        this.payPrice = this.payPrice.subtract(discountPrice);
    }

    public void calcPrice() {
        //自带款式
        if (ownProduce != null) {
            price = ownProduce.getPrice();

        }
        //预约款式
        else if (produceId != null) {
            if (discountRate == null) {
                //没有活动价格
                if (promotionPrice == null) {
                    price = produceCurrentPrice;
                }
                //有活动价
                else {
                    price = produceCurrentPrice.min(promotionPrice);
                }
            } else {
                leisurePrice = produceBargainPrice.multiply(discountRate);
                //没有活动价格
                if (promotionPrice == null) {
                    price = leisurePrice.min(produceCurrentPrice);
                }
                //有活动价
                else {
                    price = leisurePrice.min(produceCurrentPrice).min(promotionPrice);
                }
            }
        }
        //预约服务
        else {
            if (discountRate == null) {
                price = servePrice;
            } else {
                leisurePrice = servePrice.multiply(discountRate);
                price = leisurePrice;
            }
        }

    }


    public Boolean isActivity() {
        return price.equals(leisurePrice) ||
                price.equals(promotionPrice) ||
                (price.equals(produceCurrentPrice) && produceCurrentPrice.compareTo(produceBargainPrice) < 0);
    }


    public void calcTimesCardAchievement(TimesCardUsedRecord timesCardUsedRecord) {
        this.achievement = this.achievement.subtract(timesCardUsedRecord.getDiscountAmount()).add(timesCardUsedRecord.getPayAmount());
    }

    public void setAchievement(BigDecimal achievement) {
        this.achievement = achievement.max(BigDecimal.ZERO);
    }
}