package com.gogirl.infrastructure.mapper.product.serve;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.product.serve.BaseProduce;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by yinyong on 2018/8/23.
 */

@Repository
public interface BaseProduceMapper extends BaseMapper<BaseProduce> {

    int insertProduceServe(@Param("serveId") Integer serveId, @Param("id") Integer id);

    BaseProduce getProduceForDetail(Integer id);

    int updateProduceServe(BaseProduce baseProduce);

    int updateProduceById(BaseProduce baseProduce);

    @Deprecated
    List<BaseProduce> queryNewServePage(@Param("customerId") Integer customerId,
                                        @Param("produceLabelId") Integer produceLabelId);

    @Deprecated
    List<BaseProduce> queryHotServePage(@Param("customerId") Integer customerId,
                                        @Param("produceLabelId") Integer produceLabelId);

    /**
     * 分页查询款式
     *
     * @param page
     * @param featuresId
     * @param serveTypeId
     * @param sort
     * @return
     */
    IPage<BaseProduce> queryProducePage(IPage<BaseProduce> page,
                                        @Param("colorSystemId") Integer colorSystemId,
                                        @Param("featuresId") Integer featuresId,
                                        @Param("serveTypeId") Integer serveTypeId,
                                        @Param("sort") Integer sort);
}
