package com.gogirl.shared.user.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class CustomerBalanceRecordDTO {

    private Integer id;

    @ApiModelProperty("客户id")
    private Integer customerId;

    @ApiModelProperty("钱去到哪里了：1:用户端微信支付,2:会员卡收款,3:其他(目前没用到),4:用户端微信支付充值,5:pos收款," +
            "6:现金收款,7:大众点评收款,8:微信扫码支付,9:团购,10:免单" +
            "11:")
    private Integer source;

    @ApiModelProperty("这笔记录来自于哪里：1:充值，2:首次充值，3:商城订单扣款:,-1:预约订单扣款")
    private Integer type;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    @ApiModelProperty("当前余额")
    private Integer currentBalance;

    @ApiModelProperty("该笔记录金额")
    private Integer orderAmount;

    @ApiModelProperty("新版本订单id,原order_id没用了")
    private Integer newOrderId;

    private Double discount;

    @ApiModelProperty("赠送金额")
    private Integer bestowAmount;

    private String orderId;

    @ApiModelProperty("订单状态")
    private Integer orderState;

    private String ip;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("推荐人，美甲师id")
    private String refereeId;

    @ApiModelProperty("店铺id")
    private Integer departmentId;

}
