package com.gogirl.interfaces.xcx;

import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.annotation.GogirlMember;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

@RestController
@Slf4j
@Api(tags = {"手机号码相关接口"})
@AllArgsConstructor
public class PhoneLoginController {
    private final GogirlTokenService gogirlTokenService;


    private final StoreTechnicianService storeTechnicianService;

    @ApiOperation(value = "获取验证码，用于绑定手机号码")
    @PostMapping("/customer/phone/getBindCode")
    @GogirlShop
    @GogirlMember
    public JsonResult<String> getBindCode(@RequestParam String phone,
                                          @RequestHeader String token) {
        String code = gogirlTokenService.getBindCode(phone);
        return JsonResult.success(code);
    }

    @ApiOperation(value = "小程序用户根据验证码绑定手机号码和称呼 生日的格式是:yyyy-MM-dd")
    @PostMapping("/customer/phone/bindPhoneAndName")
    public JsonResult<Customer> bindPhoneAndCode(@RequestHeader String token,
                                                 @RequestParam String phone,
                                                 @RequestParam String code,
                                                 @RequestParam String realName,
                                                 @RequestParam
                                                 @DateTimeFormat(pattern = "yyyy-MM-dd") Date birthday,
                                                 @RequestParam String sex) {
        Customer customer = gogirlTokenService.bindPhoneAndCode(phone, code, realName, birthday, sex);
        return JsonResult.success(customer);

    }

    @ApiOperation(value = "获取验证码，用于绑定手机号码")
    @PostMapping("/technician//phone/getBindCode")
    public JsonResult<String> techGetBindCode(@RequestParam String phone) {
        String code = gogirlTokenService.getBindCode(phone);
        return JsonResult.success(code);
    }


    @ApiOperation(value = "美甲师根据验证码绑定手机号码")
    @PostMapping("/technician/phone/bindPhone_t")
    public JsonResult<Void> bindPhone_t(@RequestHeader String token,
                                        @RequestParam String phone,
                                        @RequestParam String code,
                                        @RequestParam String messageCode) {
        gogirlTokenService.bindTechnicianIdPhone(phone, code, messageCode);
        return JsonResult.success();
    }


}
