package com.gogirl.interfaces.order.serve;

import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.shared.member.order.command.CreateCommentCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * 订单评价
 */
@Api(tags = {"预约订单评论接口"}, value = "预约订单评论接口")
@RestController
@AllArgsConstructor
@Slf4j
public class OrderCommentController {


    private final OrderManageService orderManageService;
    private GogirlTokenService gogirlTokenService;

    /**
     * 发表服务评论
     *
     * @param cmd 发表评论入参
     * @return integer
     */
    @PostMapping("/customer/ordercomment/addOrModifyOrderComment")
    @ApiOperation(value = "订单服务评论")
    public JsonResult<List<OrderServe>> addOrModifyOrderComment(@RequestHeader String token,
                                                                @RequestBody CreateCommentCommand cmd) {

        Integer currentCustomerId = Optional.ofNullable(gogirlTokenService.getByToken(token).getCustomerId())
                .orElseThrow(() -> new RRException(500, "token不存在"));
        cmd.setCurrentCustomerId(currentCustomerId);
        log.info("订单评论开始 **");
        List<OrderServe> orderServeList = orderManageService.addOrModifyOrderComment(cmd);
        log.info("订单评论结束 **");
        return JsonResult.success();
    }
}
