package com.gogirl.infrastructure.mapper.order.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.order.serve.OrderServeDescribe;

import java.util.List;


public interface OrderServeDescribeMapper extends BaseMapper<OrderServeDescribe> {


    /**
     * 根据类型查询所有订单服务描述
     *
     * @param type {@link OrderServeDescribe#getType()}
     * @return
     */
    List<OrderServeDescribe> selectByType(Integer type);

    /**
     * 根据订单服务id查询所有订单服务描述
     *
     * @param id 订单服务id {@link OrderServe#getId()}
     * @return 所有订单服务描述 {@link OrderServeDescribe}
     */
    List<OrderServeDescribe> selectByOrderServeId(Integer id);
}
