package com.gogirl.shared.product;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

@ApiModel("闲时折扣列表项")
@Data
public class LeisureScheduleServeResp {

    @ApiModelProperty("闲时折扣")
    private Integer leisureDiscountConfigId;

    @ApiModelProperty("折扣率")
    private BigDecimal discountRate;

    @ApiModelProperty("店铺id")
    private Integer departmentId;

    @ApiModelProperty("时间节点")
    @JsonFormat(pattern = "HH:mm:ss")
    private LocalTime timeNode;

    @ApiModelProperty("日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate weekDate;

    @ApiModelProperty("服务")
    private Integer serveId;

    @ApiModelProperty("服务名")
    private String serveName;

    @ApiModelProperty("店铺名")
    private String departmentName;

    @ApiModelProperty("经度")
    private Double latitude;

    @ApiModelProperty("纬度")
    private Double longitude;

    @ApiModelProperty("距离")
    private Double distance;

    @ApiModelProperty("日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime dateTime;

    @ApiModelProperty("可用美甲师")
    private List<StoreTechnician> storeTechnicianList;
}
