package com.gogirl.application.order.serve;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.shared.member.order.command.BalanceWxPayQuery;
import com.gogirl.shared.member.order.query.UnifiedOrderQuery;

import java.net.UnknownHostException;

public interface PayService {
    /**
     * 余额消费
     * 1.余额消费
     * 2.设置订单折扣详情，包括次卡抵扣状态、内部券抵扣详情、外部券抵扣详情
     * 3.更新预约订单状态
     *
     * @param currentCustomerId 当前客户id
     * @param orderId           预约订单id
     */
    void consumeBalance(Integer currentCustomerId, Integer orderId);


    /**
     * 预约订单支付回调
     * 1.设置订单折扣详情，包括次卡抵扣状态、内部券抵扣详情、外部券抵扣详情
     * 2.更新预约订单状态
     *
     * @param scheduleOrderNo 预约订单编号
     * @param paymentType     支付类型
     */
    void notifyOrder(String scheduleOrderNo, Integer paymentType);


    /**
     * 微信支付预约订单
     *
     * @param qry
     * @return
     */
    WxPayMpOrderResult unifiedOrder(UnifiedOrderQuery qry) throws UnknownHostException, WxPayException;

    /**
     * 余额微信余额支付
     *
     * @param qry
     * @return
     */
    WxPayMpOrderResult balanceWxPay(BalanceWxPayQuery qry) throws UnknownHostException, WxPayException;


    /**
     * 余额pos支付
     *
     * @param currentCustomerId
     * @param orderId
     */
    void balancePosPay(Integer currentCustomerId, Integer orderId);

    /**
     * 更新选择支付方式
     *
     * @param orderId
     * @param payType
     */
    void chosePayType(Integer orderId, Integer payType);
}
