package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.domain.store.store.StoreGuide;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.store.store.StoreGuideMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.util.MapDistance;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/9/17.
 */
@Service
@AllArgsConstructor
public class StoreManageServiceImpl extends ServiceImpl<StoreManageMapper, StoreManage> implements StoreManageService {

    private final StoreManageMapper storeManageMapper;

    @Override
    public IPage<StoreManage> listShopManageForPage(IPage<StoreManage> page, StoreManage storeManage) {
        return storeManageMapper.listShopManageForPage(page,storeManage);
    }


    @Override
    public List<StoreManage> getTechnicianShopList() {
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        if (gogirlToken == null) {
            throw new RRException(2000, "token失效，请重新登陆");
        }
        return storeManageMapper.getTechnicianShopList(SessionUtils.getTechnicianId());
    }

    private final StoreGuideMapper storeGuideMapper;

    @Override
    public StoreManage getShopManageForDetail(Integer id, String longitude, String latitude) {
        StoreManage storeManage = storeManageMapper.selectById(id);

        if (latitude != null && longitude != null && !latitude.equals("undefined") && !longitude.equals("undefined")) {
            Double arg0 = MapDistance.getDistance(longitude, latitude, storeManage.getLongitude(), storeManage.getLatitude());
            storeManage.setDistance(arg0);
        }

        List<StoreGuide> storeGuideList = storeGuideMapper.selectList(new LambdaQueryWrapper<StoreGuide>().eq(StoreGuide::getDepartmentId, storeManage.getId()));
        storeManage.setStoreGuideDTOList(storeGuideList);
        return storeManage;
    }
}
