package com.gogirl.application.market;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.market.coupon.Coupon;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;

import java.util.List;


public interface CouponService extends IService<Coupon> {


    /**
     * 获取统一卡券领取的张数
     *
     * @param couponId   couponId
     * @param customerId customerId
     * @return count
     */
    int countRelevanceNum(Integer couponId, Integer customerId);


    /**
     * 给用户发券 并且修改卡券已领取人数
     *
     * @param coupon 卡券类型
     * @param record 卡券实体
     * @return true
     */
    int insertSelective(Coupon coupon, CouponCustomerRelevance record);



    /**
     * 查询是否领过对应卡券
     *
     * @param customerId   用户id
     * @param couponIdList 卡券类型id
     * @return
     */
    List<CouponCustomerRelevance> selectMyNewCustomerCoupon(Integer customerId, List<Integer> couponIdList);


    /**
     * 是否新人
     *
     * @param customerId
     * @return
     */
    Coupon checkNewCustomer(Integer customerId);

    /**
     * 发放新人券
     *
     * @param customerId 用户id
     * @return
     */
    Coupon sendNewCustomerCouponXcx(Integer customerId);

    /**
     * 发券
     *
     * @param couponId   卡券配置id
     * @param customerId 用户id
     * @return
     */
    Coupon sendCoupon(Integer couponId, Integer customerId);

    /**
     * 查询订单可用外部券
     *
     * @param orderId
     * @return
     */
    List<Coupon> getOrderExternalCoupon(Integer orderId);

    /**
     * 美甲师提交订单
     *
     * @param orderId   订单id
     * @param couponIds 外部券配置id list
     */
    void techSubmitCoupons(Integer orderId, List<Integer> couponIds);
}
