package com.gogirl.interfaces.xcx;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.annotation.GogirlMember;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.CustomerMapper;
import com.gogirl.infrastructure.sms.SmsService;
import com.gogirl.infrastructure.util.CheckUtil;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

@RestController
@Slf4j
@Api(tags = {"version2.0: 手机号码相关接口"}, value = "version2.0: 手机号码相关接口")
@AllArgsConstructor
public class PhoneLoginController {
    private final SmsService smsService;
    private final GogirlTokenService gogirlTokenService;


    private final CustomerMapper customerMapper;
    private final StoreTechnicianService storeTechnicianService;

    @ApiOperation(value = "获取验证码，用于绑定手机号码")
    @PostMapping("/customer/phone/getBindCode")
    @GogirlShop
    @GogirlMember
    public JsonResult<String> getBindCode(@RequestParam String phone, String token) {
        if (token == null || token.isEmpty()) {
            return new JsonResult<>(false, "入参token为空", null);
        }
        if (!CheckUtil.isPhone(phone)) {
            log.info("用户号码格式不正确");
            return new JsonResult<>(false, "用户号码格式不正确", null);
        }
        GogirlToken gt = gogirlTokenService.getByToken(token);
        if (gt == null) {
            return new JsonResult<>(false, "TOKEN_NULL_CODE", "token过期");
        }
        String code = getNewCode();
        SmsSingleSenderResult result = smsService.sendBindSmsCode(phone, code);
        if (result != null) {
            //验证码保存到TOKEN
            gt.setCode(code);
            gt.setPhone(phone);
            gogirlTokenService.updateById(gt);
            return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, null);
        } else {
            return new JsonResult<>(false, "发送验证码失败，请重试", null);
        }
    }

    @ApiOperation(value = "小程序用户根据验证码绑定手机号码和称呼", notes = "生日的格式是:yyyy-MM-dd")
    @PostMapping("/customer/phone/bindPhoneAndName")
    public JsonResult<Customer> bindPhoneAndCode(@RequestHeader String token,
                                                 @RequestParam String phone,
                                                 @RequestParam String code,
                                                 @RequestParam String realName,
                                                 @RequestParam
                                                 @DateTimeFormat(pattern = "yyyy-MM-dd") Date birthday,
                                                 @RequestParam String sex) {

        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);

        Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());

        customer.setRealName(realName);
        customer.setBirthday(birthday);
        customer.setSex(sex);
        customer.setPhone(phone);

        List<Customer> phoneCustomer = customerMapper.selectList(new LambdaQueryWrapper<Customer>()
                .eq(Customer::getPhone, phone));

        if (ListUtil.isNotEmpty(phoneCustomer)) {
            throw new RRException("手机号已经使用");
        }
        //更新用户
        customerMapper.updateById(customer);
        return JsonResult.success(customer);
    }

    @ResponseBody
    @ApiOperation(value = "获取验证码，用于绑定手机号码")
    @PostMapping("/technician//phone/getBindCode")
    public JsonResult<String> techGetBindCode(@RequestParam String phone) {

        if (!CheckUtil.isPhone(phone)) {
            log.info("用户号码格式不正确");
            throw new RRException("用户号码格式不正确");
        }
        String code = getNewCode();
        SmsSingleSenderResult result = smsService.sendBindSmsCode(phone, code);
        if (result != null) {
            //todo 验证码逻辑
            return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, null);
        } else {
            return new JsonResult<>(false, "发送验证码失败，请重试", null);
        }
    }

    private final WechatService wechatService;
    private final StoreManageMapper storeManageMapper;

    @ApiOperation(value = "美甲师根据验证码绑定手机号码")
    @PostMapping("/technician/phone/bindPhone_t")
    public JsonResult<Void> bindPhone_t(@RequestHeader String token,
                                        @RequestParam String phone,
                                        @RequestParam String code,
                                        @RequestParam String messageCode) {
        Code2SessionResult responseResult = wechatService.getTechnicianOpenidByCode(code);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }

        String openid = responseResult.getOpenid();

        StoreTechnician storeTechnician = storeTechnicianService.getOne(new LambdaQueryWrapper<StoreTechnician>().eq(StoreTechnician::getMobile, phone));
        if (storeTechnician == null) {
            throw new RRException("请联系管理员添加美甲师");
        }
        List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(storeTechnician.getId());
        if (ListUtil.isEmpty(storeManageList)) {
            throw new RRException("请联系管理员添加美甲师");
        }

        if (StringUtils.isNotEmpty(storeTechnician.getOpenid())) {
            throw new RRException("已经绑定过手机号");
        }
        storeTechnician.setOpenid(openid);
        storeTechnicianService.updateById(storeTechnician);
        return JsonResult.success();
    }

    private String getNewCode() {
        return String.valueOf((int) ((Math.random() * 9 + 1) * 100000));
    }


}
