package com.gogirl.domain.store.oa;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 调休记录表
 */
@Data
@TableName("over_time_record_log")
public class OverTimeRecordLog {

    @JsonSerialize(using = ToStringSerializer.class)
    @TableId(type = IdType.AUTO)
    private Long id;

    private Long overTimeRecordId;

    private Long takeLeaveEventId;

    @ApiModelProperty("时长")
    private BigDecimal lengthTime;

    private Long createTime;

    public OverTimeRecordLog() {
        this.createTime = System.currentTimeMillis();
    }
}
