package com.gogirl.domain.market.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel("预约卡券订单关联")
@TableName("coupon_order_relevance")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CouponOrderRelevance {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("卡券领取记录表")
    private Integer couponCustomerRelevanceId;

    private Integer orderId;

    @ApiModelProperty("订单服务id")
    private Integer orderServeId;

    private String serveName;

    @ApiModelProperty("卡券在这个服务上实支付金额")
    private BigDecimal payForOrderServe;

    @ApiModelProperty("订单服务抵扣金额")
    private BigDecimal discountAmount;

    private Date createTime;

    private Integer couponId;

    private Integer customerId;

    private Integer technicianId;

    private String message;

    private Integer status;

    private Date confirmTime;

    private String couponName;

    private Coupon coupon;
}

