package com.gogirl.application.store.store.impl;


import com.gogirl.application.store.store.CustomerDepartmentRelevanceService;
import com.gogirl.domain.user.CustomerDepartmentRelevance;
import com.gogirl.domain.user.CustomerDepartmentRelevanceKey;
import com.gogirl.infrastructure.mapper.user.CustomerDepartmentRelevanceMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
@Slf4j
@AllArgsConstructor
public class CustomerDepartmentRelevanceServiceImpl implements CustomerDepartmentRelevanceService {

    private final CustomerDepartmentRelevanceMapper customerDepartmentRelevanceDao;

    public void insertDepartmentRelevanceIfNotExist(Integer customerId, Integer departmentId, Integer source, Date relevanceTime) {
        CustomerDepartmentRelevanceKey key = new CustomerDepartmentRelevanceKey();
        key.setCustomerId(customerId);
        key.setDepartmentId(departmentId);
        CustomerDepartmentRelevance re = customerDepartmentRelevanceDao.selectByPrimaryKey(key);
        if (re != null) {//不做更新

        } else {//插入
            CustomerDepartmentRelevance record = new CustomerDepartmentRelevance();
            record.setCustomerId(customerId);
            record.setDepartmentId(departmentId);
            record.setRelevanceSource(source);
            record.setRelevanceTime(relevanceTime);
            customerDepartmentRelevanceDao.insertSelective(record);
        }
    }
}
