package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.domain.product.features.BaseFeatures;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseProduceServe;
import com.gogirl.infrastructure.mapper.product.fetures.BaseFeaturesMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseProduceMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/8/23.
 */
@Service
@AllArgsConstructor
public class BaseProduceServiceImpl extends ServiceImpl<BaseProduceMapper, BaseProduce> implements BaseProduceService {

    private final BaseProduceMapper baseProduceMapper;
    private final BaseFeaturesMapper baseFeaturesMapper;

    @Override
    public BaseProduce getProduceForDetail(Integer id) {
        return baseProduceMapper.getProduceForDetail(id);
    }

    @Override
    public void updateProduceById(BaseProduce baseProduce) {
        if (baseProduce.getStatus() != null) {
            baseProduceMapper.updateProduceById(baseProduce);
            return; // 用于修改上下线状态
        }
        BaseProduceServe baseProduceServe = baseProduceMapper.checkProduceServe(baseProduce.getId());
        //
        if (baseProduceServe != null) {
            baseProduceMapper.updateProduceServe(baseProduce); //修改服务款式关联关系
        }
        //
        else {
            baseProduceMapper.insertProduceServe(baseProduce.getServiceId(), baseProduce.getId()); //新增服务款式关联关系
        }
        baseProduceMapper.updateProduceById(baseProduce);
    }

    @Override
    public List<BaseProduce> queryNewServePage(Integer cusId, Integer produceLabelId) {
        BaseFeatures baseFeatures = baseFeaturesMapper.selectById(produceLabelId);
        //热销款根据销量排序
        if (baseFeatures != null && baseFeatures.getName().equals("热销款")) {
            return baseProduceMapper.queryHotServePage(cusId, produceLabelId);
        }
        //其他标签根据款式index_sort排序
        return baseProduceMapper.queryNewServePage(cusId, produceLabelId);
    }

}
