package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.mall.PurchaseSkuService;
import com.gogirl.domain.product.mall.PurchaseSku;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.order.mall.PurchaseSkuMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class PurchaseSkuServiceImpl extends ServiceImpl<PurchaseSkuMapper, PurchaseSku> implements PurchaseSkuService {

    @Resource
    PurchaseSkuMapper purchaseSkuMapper;

    @Override
    public IPage<PurchaseSku> queryPagePurchaseSku(Integer pageNum, Integer pageSize, Long mallCategoryId) {
        IPage<PurchaseSku> purchaseSkuIPage = new Page<>(pageNum, pageSize);

        if (mallCategoryId == null) {
            return this.page(purchaseSkuIPage);
        }
        return purchaseSkuMapper.queryPagePurchaseSku(purchaseSkuIPage, mallCategoryId);
    }

    @Override
    public IPage<PurchaseSku> queryPage(Integer pageNum, Integer pageSize, String keyWord) {
        IPage<PurchaseSku> purchaseSkuIPage = new Page<>(pageNum, pageSize);

        LambdaQueryWrapper<PurchaseSku> wrapper = new LambdaQueryWrapper<>();
        if (StringUtils.isNotEmpty(keyWord)) {
            wrapper.eq(PurchaseSku::getSkuName, keyWord);
        }
        return purchaseSkuMapper.selectPage(purchaseSkuIPage, wrapper);
    }

    @Override
    public PurchaseSku getPurchaseSku(Integer purchaseSkuId) {
        return this.getById(purchaseSkuId);
    }
}
