package com.gogirl.shared.market;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("预下单订单详情")
public class MallOrderDetailCreateDTO {

    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("商定的skuId")
    private Integer purchaseSkuId;

    @ApiModelProperty("数量")
    private Integer num;

    /**
     * 冗余PurchaseSku字段
     */
    @ApiModelProperty("sku码")
    private String sku;

    @ApiModelProperty("图片路径,用逗号隔开多张图片")
    private String picturePath;

    @ApiModelProperty("商品名字")
    private String skuName;

    @ApiModelProperty("商品类型表的id")
    private Integer skuType;

    @ApiModelProperty("商品型号描述")
    private String skuModel;

    @ApiModelProperty("店铺看到的价格")
    private BigDecimal shopPrice;

    @ApiModelProperty("采购价格")
    private BigDecimal purchasePrice;

    @ApiModelProperty("供应商描述")
    private String supplier;


    /**
     *
     */
    @ApiModelProperty("订单详情总金额")
    private BigDecimal amount;

    @ApiModelProperty("详情优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("详情支付总金额")
    private BigDecimal payAmount;
}
