package com.gogirl.infrastructure.feign;

import com.gogirl.infrastructure.common.util.JsonUtilByJackson;
import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.AdminResult;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 10:35 上午
 */
@ActiveProfiles("dev")
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@EnableFeignClients(clients = AdminFeign.class)
public class AdminFeignTest {

    @Resource
    private AdminFeign adminFeign;

    @Test
    public void getStoreTrendApi() {
        GetStoreTrendApiRequest request = new GetStoreTrendApiRequest();

        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        request.setSearchType(1);
        request.setUserStoreIds(Lists.newArrayList(19));
        request.setFields(Lists.newArrayList());

        String postJson = JsonUtilByJackson.writeValueAsString(request);
        log.info(postJson);
        AdminResult<GetStoreTrendApiResp> result = adminFeign.getStoreTrendApi(request);
        log.info("time end");
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }


    @Test
    public void getStoreListApi() {

        GetStoreListApiRequest request = new GetStoreListApiRequest();
        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        request.setTitle("2");
        AdminResult<List<Map<String, Object>>> result = adminFeign.getStoreListApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));

    }


    @Test
    public void preStorageSumApi() {

        PreStorageSumApiRequest request = new PreStorageSumApiRequest();
        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        AdminResult<Map<String, Object>> result = adminFeign.preStorageSumApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));

    }

    @Test
    public void revenueSumByTypeApi() {
        RevenueSumByTypeApiRequest request = new RevenueSumByTypeApiRequest();
        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        AdminResult<Map<String, Object>> result = adminFeign.revenueSumByTypeApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }

    @Test
    public void revenueTypeListApi() {
        RevenueTypeListRequest request = new RevenueTypeListRequest();
        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        AdminResult<List<Map<String, Object>>> result = adminFeign.revenueTypeListApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }


    @Test
    public void revenueSumApi() {
        RevenueSumApiRequest request = new RevenueSumApiRequest();
        request.setDateUtc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        AdminResult<List<Map<String, Object>>> result = adminFeign.revenueSumApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }

    @Test
    public void getTechnicianPage() {
        GetTechnicianPageRequest request = GetTechnicianPageRequest.builder()
                .page(1)
                .rows(30)
                .sidx("grade")
                .sord("asc")
                //在职
                .status(1)
                .build();
        request.setDate_utc(Lists.newArrayList(ZonedDateTime.of(LocalDateTime.of(2020, 6, 30, 0, 0), ZoneOffset.UTC).toString(),
                ZonedDateTime.of(LocalDateTime.of(2020, 7, 30, 0, 0), ZoneOffset.UTC).toString()));

        AdminResult<AdminPage<AdminTechnicianScoreResp>> result = adminFeign.getTechnicianPage(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }

    @Test
    public void achievementsPersonaResultPageApi() {
        Calendar calendar = Calendar.getInstance();
        AchievementsPersonaResultPageApiRequest request = AchievementsPersonaResultPageApiRequest.builder()
                .page(1)
                .year(calendar.get(Calendar.YEAR))
                .month(calendar.get(Calendar.MONTH) + 1)
                .status(1)
                .page(1)
                .rows(30)
                .sidx("")
                .sord("desc")
                .technician_id(127)
                .build();

        AdminResult<AdminPage<AchievementsPersonaResult>> result = adminFeign.achievementsPersonaResultPageApi(request);
        log.info(JsonUtilByJackson.writeValueAsString(result));
    }

    @Test
    public void testTime() {
        System.out.println(LocalDateTime.now(ZoneOffset.UTC).toString());
        System.out.println(JsonUtilByJackson.writeValueAsString(LocalDateTime.now().toInstant(ZoneOffset.UTC)));
    }
}
