package com.gogirl.interfaces.product.serve;

import com.gogirl.application.product.serve.BaseTypeService;
import com.gogirl.domain.product.serve.BaseType;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@AllArgsConstructor
@Api(tags = {"服务分类接口"})
public class TypeController {

    /**
     * domain service
     */
    private final BaseTypeService baseTypeService;


    @ApiOperation("查询服务类型")
    @GetMapping("/customer/type/queryType")
    public JsonResult<List<BaseType>> queryType() {
        return JsonResult.success(baseTypeService.list());
    }


    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST}, value = "/technician/type/queryType")
    public JsonResult<List<BaseType>> technicianQueryType() {
        JsonResult<List<BaseType>> jsonResult = new JsonResult<>();
        List<BaseType> lists = baseTypeService.list();
        jsonResult.setSuccess(JsonResult.CODE_SUCCESS).setMessage(JsonResult.APP_DEFINE_SUC).setData(lists);
        return jsonResult;
    }

}
