package com.gogirl.infrastructure.mapper.product.serve;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.shared.product.CalcServiceDuration;
import com.gogirl.shared.product.serve.QueryProducePageRequest;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by yinyong on 2018/8/23.
 */

@Repository
public interface BaseProduceMapper extends BaseMapper<BaseProduce> {

    /**
     * 通过resultMap获取款式详情
     *
     * @param id id
     * @return 款式详情
     */
    BaseProduce getProduceForDetail(Integer id);


    /**
     * 分页查询款式
     *
     * @param page
     * @param request
     * @return
     */
    IPage<BaseProduce> queryProducePage(IPage<BaseProduce> page,
                                       @Param("request") QueryProducePageRequest request);

    /**
     * 同步款式服务类型id
     */
    void syncProduceServeTypeId();

    /**
     * 同步款式销量
     */
    void syncSalesNum();

    List<CalcServiceDuration> queryProduceServiceDuration();
}
