package com.gogirl.infrastructure.interceptor;

import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.user.customer.StoreUserMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@AllArgsConstructor
@Slf4j
public class SessionHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final CustomerService customerService;

    private final StoreTechnicianMapper storeTechnicianMapper;
    private final StoreManageMapper storeManageMapper;
    private final StoreUserMapper storeUserMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        String sourceFrom = request.getHeader("sourceFrom");
        SessionUtils.putSourceFrom(sourceFrom);
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            long time = System.currentTimeMillis();
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken != null) {
                SessionUtils.putCustomerToken(gogirlToken);
            }
            HandlerMethod h = (HandlerMethod) handler;
            log.info(h.getMethod() + "消耗时间：" + (System.currentTimeMillis() - time));
        }

        if (sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken != null) {
                SessionUtils.putTechnicianToken(gogirlToken);
            }
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SessionUtils.removeCustomerToken();
        SessionUtils.removeTechnicianToken();
        SessionUtils.removeSourceFrom();
    }

}
