package com.gogirl.wxappmember.interfaces.order.mall;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.WebApplicationContext;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@Transactional(timeout = 10000)
public class MallRefundOrderControllerTest {

    private MockMvc mockMvc;

    @Autowired
    private WebApplicationContext wac;

    @Before
    public void beforeSetUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    @Test
    public void refundOrder() throws Exception {
        mockMvc.perform(
                MockMvcRequestBuilders.get("/mallRefundOrder/refundOrder")
                        .content("{\"mallRefundOrder\":{\"refundContactName\":\"柚子\",\"refundContactPhone\":\"13454565656\",\"refundReason\":\"理由1\",\"mallOrderId\":\"1203920657637679106\"},\"token\":\"8bf498d7ac\"}")
                        .contentType(MediaType.APPLICATION_JSON_UTF8))
                .andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void queryRefundReason() {
    }
}
