package com.gogirl.wxappmember.application.order.serve.command.impl;

import com.gogirl.domain.market.serve.DiscountConfig;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.JsonUtilByJackson;
import com.gogirl.infrastructure.mapper.market.DiscountConfigMapper;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Comparator;
import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@Transactional
public class PayServiceImplTest {

    @Resource
    DiscountConfigMapper discountConfigMapper;
    @Resource
    StoreTechnicianMapper storeTechnicianMapper;

    @Test
    public void notifyCharge() {
        DiscountConfig discountConfig = discountConfigMapper.selectAllDiscount().stream().filter(config -> config.getChargeAmount() < 1).max(Comparator.comparing(DiscountConfig::getChargeAmount)).orElseThrow(RRException::new);
        if (discountConfig == null) {

        }
    }

    @Test
    public void test() {

        List<StoreClassesTechnician> oldVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24014,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":95},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        oldVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByJackson.writeValueAsString(oldVal));

        List<StoreClassesTechnician> newVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        newVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByJackson.writeValueAsString(newVal));
    }

    public void syncOrderServePrice() {

    }
}