package com.gogirl.wxappmember;

import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import lombok.AllArgsConstructor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.List;

//@Suite.SuiteClasses({
////    OrderManageControllerTest.class
//})
//@RunWith(Suite.class)
@AllArgsConstructor
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
class GogirlWxappShopBackendApplicationTests {

    private final StoreTechnicianMapper storeTechnicianMapper;

    @Test
    public void contextLoads() {

        List<StoreClassesTechnician> oldVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24014,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":95},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        oldVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByFsJson.beanToJson(oldVal));

        List<StoreClassesTechnician> newVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        newVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByFsJson.beanToJson(newVal));
    }

    @Test
    public void test() {

        List<StoreClassesTechnician> oldVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24014,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":95},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        oldVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByFsJson.beanToJson(oldVal));

        List<StoreClassesTechnician> newVal = JsonUtilByFsJson.jsonToList("[{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":23985,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":79},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24043,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":96},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24072,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":99},{\"classes\":5,\"classesManage\":null,\"days\":1581782400000,\"id\":24159,\"listScheduleServe\":[],\"status\":2,\"technicianManage\":null,\"userId\":128}]"
                , StoreClassesTechnician.class);
        newVal.forEach(val -> val.setTechnicianManage(storeTechnicianMapper.selectById(val.getUserId())));
        System.out.println(JsonUtilByFsJson.beanToJson(newVal));
    }

}
