package com.gogirl.interfaces.wxappmember.xcx;

import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.VisitLogService;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.VisitsLog;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AllArgsConstructor
@Api(tags = {"version2.0: 消息接口"})
@Slf4j
public class MessageController {

    private final GogirlTokenService gogirlTokenService;
    private final VisitLogService visitLogService;

    @ApiOperation(value = "小程序登入记录")
    @PostMapping("/customer/message/loginLog")
    public JsonResult<Integer> loginLog(@RequestHeader String token) {
        Integer customerId = gogirlTokenService.getTokenByToken(token).getCustomerId();
        VisitsLog visitsLog = visitLogService.loginLog(customerId);
        return JsonResult.success(visitsLog.getId());
    }

    @ApiOperation(value = "小程序登出记录")
    @PostMapping("/customer/message/logoutLog")
    public JsonResult<Void> logoutLog(@RequestHeader String token,
                                      @RequestParam Integer visitsId) {
        visitLogService.logoutLog(visitsId);
        return JsonResult.success();
    }

    @ApiOperation(value = "记录该次访问的活动")
    @PostMapping("/customer/message/recordActivityId")
    public JsonResult<Void> recordActivityId(@RequestHeader String token,
                                             @RequestParam Integer visitsId,
                                             @RequestParam Integer activityId) {

        visitLogService.recordActivityId(visitsId, activityId);
        return JsonResult.success();

    }

    @ApiOperation(value = "页面登入记录", notes = "参数直接传过来")
    @PostMapping("/customer/message/pageIn")
    public JsonResult<Integer> pageIn(@RequestHeader String token,
                                      @RequestParam(required = false) Integer type,
                                      @RequestParam(required = false) Integer activityId,
                                      @RequestParam(required = false) Integer shareType,
                                      @RequestParam(required = false) Integer shareUserId,
                                      @RequestParam(required = false) Integer serviceId,
                                      @RequestParam(required = false) Integer departmentId,
                                      @RequestParam(required = false) String pageName,
                                      @RequestParam(required = false) Integer produceId) {

        GogirlToken gt = gogirlTokenService.getTokenByToken(token);
        Integer customerId = gt.getCustomerId();
        VisitsLog visitsLog = visitLogService.pageIn(customerId, type, activityId, shareType, shareUserId, serviceId, departmentId, pageName, produceId);
        return JsonResult.success(visitsLog.getId());
    }


    @ApiOperation(value = "页面登出记录")
    @PostMapping("/customer/message/pageOut")
    public JsonResult<Void> pageOut(@RequestHeader String token,
                                    @RequestParam Integer visitsId) {
        visitLogService.pageOut(visitsId);
        return JsonResult.success();
    }
}
