package com.gogirl.interfaces.wxappmember.user;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.user.customer.CustomerDetailService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderRecord;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.user.CustomerBalance;
import com.gogirl.domain.user.CustomerDetail;
import com.gogirl.domain.xcx.GogirlConfig;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.order.serve.OrderRecordMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.CustomerDetailMapper;
import com.gogirl.infrastructure.mapper.user.CustomerMapper;
import com.gogirl.infrastructure.mapper.xcx.GogirlConfigMapper;
import com.gogirl.infrastructure.util.CheckUtil;
import com.gogirl.infrastructure.util.CountCustomerRate;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = {"version3.0: 小程和用户相关接口"}, value = "version3.0: 小程和用户相关接口")
@RestController
@AllArgsConstructor
@Slf4j
public class CustomerController {
    private final CustomerService customerService;
    private final CustomerDetailService customerDetailService;
    private final OrderManageService orderManageService;
    private final GogirlConfigMapper gogirlConfigMapper;

    private final CustomerMapper customerMapper;
    private final CustomerDetailMapper customerDetailMapper;
    private final StoreManageMapper shopManageMapper;
    private final OrderRecordMapper orderRecordMapper;
    private final OrderServeMapper orderServeMapper;
    private final CustomerBalanceMapper customerBalanceMapper;

    private final BaseServeMapper baseServeMapper;

    @ApiOperation(value = "查询用户可选年龄段", notes = "在gogirl_config中配置")
    @PostMapping("/technician/getAgeGroups")
    public JsonResult<List<String>> getAgeGroups() {
        GogirlConfig gogirlConfig = gogirlConfigMapper.selectByPrimaryKey(3);
        if (gogirlConfig == null || gogirlConfig.getValue() == null || gogirlConfig.getValue().isEmpty()) {
            return new JsonResult<>(true, "请联系管理员,在gogirl_config表中配置id=3的value,用英文逗号隔开多个选项");
        }
        String[] ageGroups = gogirlConfig.getValue().split(",");

        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, new ArrayList<>(Lists.newArrayList(ageGroups)));
    }

    @ApiOperation(value = "用户详情数据查看")
    @PostMapping("/technician/queryCustomerDetail")
    public JsonResult<Map<String, Object>> queryCustomerDetail(@RequestHeader String token,
                                                               @RequestParam Integer customerId,
                                                               @RequestParam(required = false) Integer orderId) {

        Map<String, Object> map = new HashMap<>();


        //查询用户信息
        Customer customer = customerMapper.selectById(customerId);

        //查询用户注册店铺
        StoreManage storeManage = shopManageMapper.selectById(customer.getRegisterDepartment());
        customer.setStoreManage(storeManage);

        //查询余额
        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, customerId));
        customer.setCustomerBalance(customerBalance);

        //查询会员详情
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        customer.setCustomerDetail(customerDetail);
        map.put("customer", customer);

        if (orderId != null) {
            //查询订单信息
            OrderManage orderManage = orderManageService.getById(orderId);

            List<OrderServe> orderServeList = orderServeMapper.selectList(new LambdaQueryWrapper<OrderServe>().eq(OrderServe::getOrderId, orderId));
            orderManage.setListOrderServer(orderServeList);

            orderServeList.forEach(orderServe -> {
                OrderRecord orderRecord = orderRecordMapper.selectOne(new LambdaQueryWrapper<OrderRecord>().eq(OrderRecord::getOrderServeId, orderServe.getId()));
                BaseServe baseServe = baseServeMapper.selectById(orderServe.getServeId());
                orderServe.setOrderRecord(orderRecord);
                orderServe.setServe(baseServe);
            });
            map.put("orderManage", orderManage);
        }

        return JsonResult.success(map);
    }

    @ApiOperation(value = "用户详情数据修改", notes = "picturePath为多张图片的地址，用逗号,分隔开,token暂时没有用到，customerId，orderId，orderServeId必传")
    @PostMapping("/technician/updateCustomerDetail")
    public JsonResult<String> updateCustomerDetail(@RequestHeader String token,
                                                   @RequestParam(required = false) Integer birthdayMonth,
                                                   @RequestParam(required = false) Integer birthdayDay,
                                                   @RequestParam(required = false) String ageGroup,
                                                   @RequestParam Integer customerId,
                                                   @RequestParam(required = false) Integer orderId,
                                                   @RequestParam(required = false) Integer orderServeId,
                                                   @RequestParam(required = false) String storeRecordRealName,
                                                   @RequestParam(required = false) String sex,
                                                   @RequestParam(required = false) Integer age,
                                                   @RequestParam(required = false) String job,
                                                   @RequestParam(required = false) String preference,
                                                   @RequestParam(required = false) String character,
                                                   @RequestParam(required = false) Integer customerSource) {


        //用户基本信息
        Customer customer = customerMapper.selectById(customerId);
        customer.setStoreRecordRealName(storeRecordRealName);
        customer.setSex(sex);
        customer.setCustomerSource(customerSource);
        customerMapper.updateById(customer);


        //用户详情信息
        CustomerDetail customerDetail = customerDetailMapper.selectOne(new LambdaQueryWrapper<CustomerDetail>().eq(CustomerDetail::getCustomerId, customer.getId()));
        if (customerDetail == null) {
            customerDetail = new CustomerDetail();
        }
        customerDetail.setCustomerId(customerId);
        customerDetail.setAge(age);
        customerDetail.setJob(job);
        customerDetail.setPreference(preference);
        customerDetail.setCharacter(character);
        customerDetail.setBirthdayMonth(birthdayMonth);
        customerDetail.setBirthdayDay(birthdayDay);
        customerDetail.setAgeGroup(ageGroup);

        customerDetailService.saveOrUpdate(customerDetail);


        //更新数据完整度
        customer.setDataIntegrity(new CountCustomerRate().countDataCompleteRate(customer, customerDetail));
        customerMapper.updateById(customer);

        if (orderId != null) {
            OrderManage om = orderManageService.queryOrder(orderId);
            double dataRate = CheckUtil.countOrderDataRate(customer, om);
            om.setDataIntegrity(dataRate);
            orderManageService.updateOrderDataIntegrity(om);
        }
        return JsonResult.success();
    }
}
