package com.gogirl.interfaces.wxappmember.store;

import com.gogirl.application.store.store.StoreUserService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreUser;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;


@Api(tags = {"9.店铺"}, value = "店铺")
@RestController
public class UserManageController {

    private final Logger logger = LoggerFactory.getLogger(UserManageController.class);
    @Resource
    GogirlTokenService gogirlTokenService;
    @Resource
    private StoreUserService storeUserService;

    @ApiOperation(value = "查询当前店铺的美甲师,选推荐人")
    @GetMapping("/technician/user/queryUserForAll")
    @GogirlShop
    public JsonResult<List<StoreUser>> queryUserForAll(String token) {
        GogirlToken gt = gogirlTokenService.getTokenByToken_t(token);
        if (gt == null) {
            return new JsonResult<>(false, "TOKEN_NULL_CODE");
        }
        JsonResult<List<StoreUser>> jsonResult = new JsonResult<>();
        StoreUser storeUser = new StoreUser();
        storeUser.setDepartmentId(gt.getStoreTechnician().getDepartmentId());
        List<StoreUser> lists = storeUserService.listUserForAllNotQuit(storeUser);

        jsonResult.setSuccess(JsonResult.CODE_SUCCESS)
                .setMessage(JsonResult.APP_DEFINE_SUC)
                .setData(lists);
        return jsonResult;
    }
}
