package com.gogirl.interfaces.wxappmember.store;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.store.store.TakeLeaveEventCmdService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.store.command.ApplyTakeLeaveCommand;
import com.gogirl.shared.store.command.ApprovalTakeLeaveCommand;
import com.gogirl.shared.store.query.dto.StoreTechnicianDTO;
import com.gogirl.shared.store.query.dto.TakeLeaveEventDTO;
import com.gogirl.shared.store.query.qry.PageApplyQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "version 3.0: 请假接口")
@RestController
@AllArgsConstructor
public class TakeLeaveEventController {
    /**
     * rpc service
     */
    private final TakeLeaveEventCmdService takeLeaveEventCmdService;

    private final GogirlTokenService gogirlTokenService;


    @ApiOperation("/申请请假")
    @PostMapping("/technician/takeLeave/applyTakeLeave")
    public JsonResult<Void> applyTakeLeave(@RequestHeader String token,
                                           @RequestBody ApplyTakeLeaveCommand cmd) {
        StoreTechnician storeTechnician = gogirlTokenService.getTokenByToken_t(token).getStoreTechnician();
        cmd.setApplyTechnicianId(storeTechnician.getTechnicianId());
        takeLeaveEventCmdService.applyTakeLeave(cmd);
        return JsonResult.success();
    }

    @ApiOperation("/分页查询请假接口")
    @PostMapping("/technician/takeLeave/queryPageTakeLeave")
    public JsonResult<Page<TakeLeaveEventDTO>> queryPageTakeLeave(@RequestBody PageApplyQuery qry) {
        Page<TakeLeaveEventDTO> page = takeLeaveEventCmdService.queryPageTakeLeave(qry);
        return JsonResult.success(page);
    }

    @ApiOperation("/查询请假详情")
    @PostMapping("/technician/takeLeavequeryTakeLeave/{id}")
    public JsonResult<TakeLeaveEventDTO> queryTakeLeave(@RequestHeader String token,
                                                        @PathVariable Long id) {
        TakeLeaveEventDTO takeLeaveEventDTO = takeLeaveEventCmdService.queryTakeLeave(id);

        return JsonResult.success(takeLeaveEventDTO);
    }

    @ApiOperation("/查询可以审核人员列表")
    @GetMapping("/technician/takeLeavequeryCheckTechnicianList")
    public JsonResult<List<StoreTechnicianDTO>> queryCheckTechnicianList(@RequestHeader String token) {
        StoreTechnician storeTechnician = gogirlTokenService.getTokenByToken_t(token).getStoreTechnician();
        List<StoreTechnicianDTO> list = takeLeaveEventCmdService.queryCheckTechnicianList(storeTechnician.getId(), storeTechnician.getDepartmentId());
        return JsonResult.success(list);
    }


    @ApiOperation("/审批请假")
    @PostMapping("/technician/takeLeaveapprovalTakeLeave")
    public JsonResult<Void> approvalTakeLeave(@RequestHeader String token,
                                              @RequestBody ApprovalTakeLeaveCommand cmd) {
        StoreTechnician storeTechnician = gogirlTokenService.getTokenByToken_t(token).getStoreTechnician();
        cmd.setCurrentTechnicianId(storeTechnician.getTechnicianId());
        takeLeaveEventCmdService.approvalTakeLeave(cmd);
        return JsonResult.success();
    }
}
